topic "Ssh";
[2 $$0,0#00000000000000000000000000000000:Default]
[i448;a25;kKO9;2 $$1,0#37138531426314131252341829483380:class]
[l288;2 $$2,2#27521748481378242620020725143825:desc]
[0 $$3,0#96390100711032703541132217272105:end]
[H6;0 $$4,0#05600065144404261032431302351956:begin]
[i448;a25;kKO9;2 $$5,0#37138531426314131252341829483370:item]
[l288;a4;*@5;1 $$6,6#70004532496200323422659154056402:requirement]
[l288;i1121;b17;O9;~~~.1408;2 $$7,0#10431211400427159095818037425705:param]
[i448;b42;O9;2 $$8,8#61672508125594000341940100500538:tparam]
[b42;2 $$9,9#13035079074754324216151401829390:normal]
[{_} 
[ {{10000@(113.42.0) [s0;%% [*@7;4 Ssh]]}}&]
[s1;@(0.0.255)3 &]
[s1;:Upp`:`:Ssh`:`:class: [@(0.0.255)3 class][3 _][*3 Ssh][3 _:_][@(0.0.255)3 private][3 _][*@3;3 No
Copy][3 , ][@(0.0.255)3 public][3 _][*@3;3 JobQueue]&]
[s2;#%% This class encapsulates a [^https`:`/`/en`.wikipedia`.org`/wiki`/Secure`_Shell`?oldformat`=true^ s
ecure shell] (version 2) client session. It is responsible for 
establishing, authenticating, and managing a cryptographically 
secured shell session on an SSH`-2 compliant server. Ssh class 
allows both [/ synchronous ]and [/ asynchronous ]modes of operation. 
Asynchronous requests can be queued, and are managed mainly using 
[^topic`:`/`/JobQueue`/src`/JobQueue`$en`-us`#Upp`:`:JobQueue`:`:Do`(`)^ Do()], 
[^topic`:`/`/JobQueue`/src`/JobQueue`$en`-us`#Upp`:`:JobQueue`:`:InProgress`(`)const^ I
nProgress()], [^topic`:`/`/JobQueue`/src`/JobQueue`$en`-us`#Upp`:`:JobQueue`:`:IsSuccess`(`)const^ I
sSuccess()], and [^topic`:`/`/JobQueue`/src`/JobQueue`$en`-us`#Upp`:`:JobQueue`:`:IsFailure`(`)const^ I
sFailure()] methods. See also [^topic`:`/`/JobQueue`/src`/JobQueue`$en`-us`#Upp`:`:JobQueue`:`:class^ J
obQueue]&]
[s3;%% &]
[ {{10000F(128)G(128)@1 [s0;%% [* Public Method List]]}}&]
[s3; &]
[s5;:Upp`:`:Ssh`:`:Auth`(const Upp`:`:String`&`,const Upp`:`:String`&`): [_^Upp`:`:Ssh^ S
sh][@(0.0.255) `&]_[* Auth]([@(0.0.255) const]_[_^Upp`:`:String^ String][@(0.0.255) `&]_[*@3 u
ser], [@(0.0.255) const]_[_^Upp`:`:String^ String][@(0.0.255) `&]_[*@3 pass])&]
[s2;%% Sets username and password. Returns `*this for method chaining.&]
[s3;%% &]
[s4; &]
[s5;:Upp`:`:Ssh`:`:Keys`(const Upp`:`:String`&`,const Upp`:`:String`&`,const Upp`:`:String`&`): [_^Upp`:`:Ssh^ S
sh][@(0.0.255) `&]_[* Keys]([@(0.0.255) const]_[_^Upp`:`:String^ String][@(0.0.255) `&]_[*@3 p
rikey], [@(0.0.255) const]_[_^Upp`:`:String^ String][@(0.0.255) `&]_[*@3 pubkey], 
[@(0.0.255) const]_[_^Upp`:`:String^ String][@(0.0.255) `&]_[*@3 phrase]_`=_Null)&]
[s2;%% Sets paths to private and public key files stored on disk. 
When [%-*@3 phrase] is not set, supplied password will be used 
instead to decipher the private key. Returns `*this for method 
chaining.&]
[s3;%% &]
[s4; &]
[s5;:Upp`:`:Ssh`:`:Method`(int`,Upp`:`:Value`): [_^Upp`:`:Ssh^ Ssh][@(0.0.255) `&]_[* Metho
d]([@(0.0.255) int]_[*@3 type], [_^Upp`:`:Value^ Value]_[*@3 method])&]
[s2;%% Sets the preferred [^topic`:`/`/SSH`/src`/SshTransport`$en`-us^ transport 
methods] for the given method [%-*@3 type]. Transport [%-*@3 method 
]parameter can contain either a single method, or a list of methods, 
with the most preferred method listed as first and the least 
preferred as last. Returns `*this for method chaining. See also 
[^topic`:`/`/SSH`/src`/Ssh`$en`-us`#Upp`:`:Ssh`:`:WhenConfig^ WhenConfig]&]
[s3;%% &]
[s4; &]
[s5;:Upp`:`:Ssh`:`:Methods`(Upp`:`:ValueMap`): [_^Upp`:`:Ssh^ Ssh][@(0.0.255) `&]_[* Method
s]([_^Upp`:`:ValueMap^ ValueMap]_[*@3 methods])&]
[s2;%% Sets the [^topic`:`/`/SSH`/src`/SshTransport`$en`-us^ transport 
methods]. The provided [%-*@3 methods] list should contain key`-value 
pairs where the keys represent possible method types, and the 
values represent single or multiple transport method(s), with 
the most preferred listed as first and the least preferred as 
last. Returns `*this for method chaining. See also [^topic`:`/`/SSH`/src`/Ssh`$en`-us`#Upp`:`:Ssh`:`:WhenConfig^ W
henConfig].&]
[s3;%% &]
[s4; &]
[s5;:Upp`:`:Ssh`:`:Password`(`): [_^Upp`:`:Ssh^ Ssh][@(0.0.255) `&]_[* Password]()&]
[s2;%% Sets the preferred authentication method to basic password 
authentication. Returns `*this for method chaining. See also 
[^topic`:`/`/SSH`/src`/Ssh`$en`-us`#Upp`:`:Ssh`:`:WhenAuth^ WhenAuth].&]
[s3;%% &]
[s4; &]
[s5;:Upp`:`:Ssh`:`:PublicKey`(`): [_^Upp`:`:Ssh^ Ssh][@(0.0.255) `&]_[* PublicKey]()&]
[s2;%% Sets the preferred authentication method to public key authentication. 
Returns `*this for method chaining. See also [^topic`:`/`/SSH`/src`/Ssh`$en`-us`#Upp`:`:Ssh`:`:WhenAuth^ W
henAuth].&]
[s3; &]
[s4; &]
[s5;:Upp`:`:Ssh`:`:Interactive`(`): [_^Upp`:`:Ssh^ Ssh][@(0.0.255) `&]_[* Interactive]()&]
[s2;%% Sets the preferred authentication method to keyboard`-interactive 
(challenge/response) authentication. Returns `*this for method 
chaining. See also [^topic`:`/`/SSH`/src`/Ssh`$en`-us`#Upp`:`:Ssh`:`:WhenAuth^ When
Auth], [^topic`:`/`/SSH`/src`/Ssh`$en`-us`#Upp`:`:Ssh`:`:WhenKeyboard^ WhenKeyboard
.]&]
[s3;%% &]
[s4; &]
[s5;:Upp`:`:Ssh`:`:GetSocket`(`): [_^Upp`:`:TcpSocket^ TcpSocket][@(0.0.255) `&]_[* GetSock
et]()&]
[s2;%% Returns a reference to the session socket.&]
[s3; &]
[s4; &]
[s5;:Upp`:`:Ssh`:`:GetSession`(`)const: [_^Upp`:`:SshSession^ SshSession][@(0.0.255) `*]_
[* GetSession]()_[@(0.0.255) const]&]
[s2;%% Returns the libssh2 session handle on success, NULL on failure.&]
[s3; &]
[s4; &]
[s5;:Upp`:`:Ssh`:`:GetBanner`(`)const: [_^Upp`:`:String^ String]_[* GetBanner]()_[@(0.0.255) c
onst]&]
[s2;%% Returns the server`'s banner, if available.&]
[s3; &]
[s4; &]
[s5;:Upp`:`:Ssh`:`:GetFingerprint`(`)const: [@(0.0.255) const]_[_^Upp`:`:String^ String][@(0.0.255) `&
]_[* GetFingerprint]()_[@(0.0.255) const]&]
[s2;%% Returns the computed digest of the server`'s hostkey (in raw 
bytes) on success, and an empty String on failure.&]
[s3; &]
[s4; &]
[s5;:Upp`:`:Ssh`:`:GetMethod`(int`): [_^Upp`:`:String^ String]_[* GetMethod]([@(0.0.255) in
t]_[*@3 type])&]
[s2;%% Returns the active transport method for given method [%-*@3 type]. 
Returns an empty string on failure.&]
[s3;%% &]
[s4; &]
[s5;:Upp`:`:Ssh`:`:GetMethods`(`): [_^Upp`:`:ValueMap^ ValueMap]_[* GetMethods]()&]
[s2;%% Returns a list of supported [^topic`:`/`/SSH`/src`/SshTransport`$en`-us^ transpo
rt methods] on success, and an empty list on failure. Supported 
method types are represented by `"keys`", and available methods, 
which can be a single string or a list of strings, are represented 
by `"values`". Note that all values are in lowercase letters.&]
[s3; &]
[s4; &]
[s5;:Upp`:`:Ssh`:`:GetAuthMethods`(`): [_^Upp`:`:Vector^ Vector]<[_^Upp`:`:String^ String
]>_[* GetAuthMethods]()&]
[s2;%% Returns a list of supported user authentication methods. Returns 
an empty vector on failure. The following three authentication 
methods are currently supported: [*@3 password], [*@3 publickey], 
[*@3 keyboard`-interactive]&]
[s3;%% &]
[s4; &]
[s5;:Upp`:`:Ssh`:`:Connect`(const Upp`:`:String`&`,int`):%% [%-@(0.0.255) bool][%- _][%-* C
onnect][%- (][%-@(0.0.255) const][%- _][%-_^Upp`:`:String^ String][%-@(0.0.255) `&][%- _][%-*@3 h
ost][%- , ][%-@(0.0.255) int][%- _][%-*@3 port][%- )] &]
[s5;:Upp`:`:Ssh`:`:Connect`(const Upp`:`:String`&`,int`,const Upp`:`:String`&`,const Upp`:`:String`&`): [@(0.0.255) b
ool]_[* Connect]([@(0.0.255) const]_[_^Upp`:`:String^ String][@(0.0.255) `&]_[*@3 host], 
[@(0.0.255) int]_[*@3 port], [@(0.0.255) const]_[_^Upp`:`:String^ String][@(0.0.255) `&]_[*@3 u
ser], [@(0.0.255) const]_[_^Upp`:`:String^ String][@(0.0.255) `&]_[*@3 pass])&]
[s2;%% Connects to a target machine specified at [%-*@3 host] and [%-*@3 port]. 
Returns true on success, and false on failure. Specific error 
code and message can be retrieved using [^topic`:`/`/JobQueue`/src`/JobQueue`$en`-us`#Upp`:`:JobQueue`:`:GetError`(`)const^ G
etError()] and [^topic`:`/`/JobQueue`/src`/JobQueue`$en`-us`#Upp`:`:JobQueue`:`:GetErrorDesc`(`)const^ G
etErrorDesc()] methods. It is possible to query and/or modify 
the active transport and authentication methods during the connection 
phase.This method is blocking. See also [^topic`:`/`/SSH`/src`/Ssh`$en`-us`#Upp`:`:Ssh`:`:WhenConfig^ W
henConfig], [^topic`:`/`/SSH`/src`/Ssh`$en`-us`#Upp`:`:Ssh`:`:WhenVerify^ WhenVerif
y], and [^topic`:`/`/SSH`/src`/Ssh`$en`-us`#Upp`:`:Ssh`:`:WhenAuth^ WhenAuth].&]
[s3;%% &]
[s4; &]
[s5;:Upp`:`:Ssh`:`:StartConnect`(const Upp`:`:String`&`,int`): [_^Upp`:`:Ssh^ Ssh][@(0.0.255) `&
]_[* StartConnect]([@(0.0.255) const]_[_^Upp`:`:String^ String][@(0.0.255) `&]_[*@3 host], 
[@(0.0.255) int]_[*@3 port])&]
[s5;:Upp`:`:Ssh`:`:StartConnect`(const Upp`:`:String`&`,int`,const Upp`:`:String`&`,const Upp`:`:String`&`): [_^Upp`:`:Ssh^ S
sh][@(0.0.255) `&]_[* StartConnect]([@(0.0.255) const]_[_^Upp`:`:String^ String][@(0.0.255) `&
]_[*@3 host], [@(0.0.255) int]_[*@3 port], [@(0.0.255) const]_[_^Upp`:`:String^ String][@(0.0.255) `&
]_[*@3 user], [@(0.0.255) const]_[_^Upp`:`:String^ String][@(0.0.255) `&]_[*@3 pass])&]
[s2;%% Asynchronous variant of [^topic`:`/`/SSH`/src`/Ssh`$en`-us`#Upp`:`:Ssh`:`:Connect`(const Upp`:`:String`&`,int`,const Upp`:`:String`&`,const Upp`:`:String`&`)^ C
onnect()]. Must be followed by a [^topic`:`/`/JobQueue`/src`/JobQueue`$en`-us`#Upp`:`:JobQueue`:`:Do`(`)^ D
o()] call. Returns `*this for method chaining.&]
[s3;%% &]
[s4; &]
[s5;:Upp`:`:Ssh`:`:Disconnect`(`): [@(0.0.255) bool]_[* Disconnect]()&]
[s2;%% Ends the ssh session, disconnects the client from the server, 
and releases the session resources. Returns true if the disconnection 
was clean, and false if dirty. Specific error code and message 
can be retrieved using [^topic`:`/`/JobQueue`/src`/JobQueue`$en`-us`#Upp`:`:JobQueue`:`:GetError`(`)const^ G
etError()] and [^topic`:`/`/JobQueue`/src`/JobQueue`$en`-us`#Upp`:`:JobQueue`:`:GetErrorDesc`(`)const^ G
etErrorDesc()] methods. This method is blocking.&]
[s3; &]
[s4; &]
[s5;:Upp`:`:Ssh`:`:StartDisconnect`(`): [_^Upp`:`:Ssh^ Ssh][@(0.0.255) `&]_[* StartDisconne
ct]()&]
[s2;%% Asynchronous variant of [^topic`:`/`/SSH`/src`/Ssh`$en`-us`#Upp`:`:Ssh`:`:Disconnect`(`)^ D
isconnect()]. Must be followed by a [^topic`:`/`/JobQueue`/src`/JobQueue`$en`-us`#Upp`:`:JobQueue`:`:Do`(`)^ D
o()] call. Returns `*this for method chaining.&]
[s3; &]
[s4; &]
[s5;:Upp`:`:Ssh`:`:WhenConfig: [_^Upp`:`:Event^ Event]<Ssh[@(0.0.255) `&]>_[* WhenConfig]&]
[s2;%% If this event is defined it is invoked at the beginning of 
the protocol handshake phase to allow user to query or set the 
[^topic`:`/`/SSH`/src`/SshTransport`$en`-us^ transport methods]. 
See also [^topic`:`/`/SSH`/src`/Ssh`$en`-us`#Upp`:`:Ssh`:`:Method`(int`,Upp`:`:Value`)^ M
ethod()], [^topic`:`/`/SSH`/src`/Ssh`$en`-us`#Upp`:`:Ssh`:`:Methods`(Upp`:`:ValueMap`)^ M
ethods()], [^topic`:`/`/SSH`/src`/Ssh`$en`-us`#Upp`:`:Ssh`:`:GetMethod`(int`)^ GetM
ethod()], [^topic`:`/`/SSH`/src`/Ssh`$en`-us`#Upp`:`:Ssh`:`:GetMethods`(`)^ GetMeth
ods()]. &]
[s3; &]
[s4; &]
[s5;:Upp`:`:Ssh`:`:WhenAuth: [_^Upp`:`:Event^ Event]<Ssh[@(0.0.255) `&]>_[* WhenAuth]&]
[s2;%% If this event is defined it is invoked at the beginning of 
the session authentication phase to allow user to query or set 
the authentication method(s). See also [^topic`:`/`/SSH`/src`/Ssh`$en`-us`#Upp`:`:Ssh`:`:GetAuthMethods`(`)^ G
etAuthMethods()], [^topic`:`/`/SSH`/src`/Ssh`$en`-us`#Upp`:`:Ssh`:`:Password`(`)^ P
assword()], [^topic`:`/`/SSH`/src`/Ssh`$en`-us`#Upp`:`:Ssh`:`:PublicKey`(`)^ Public
Key()], and [^topic`:`/`/SSH`/src`/Ssh`$en`-us`#Upp`:`:Ssh`:`:Interactive`(`)^ Inte
ractive()].&]
[s3; &]
[s4; &]
[s5;:Upp`:`:Ssh`:`:WhenVerify: [_^Upp`:`:Gate^ Gate]<Ssh[@(0.0.255) `&]>_[* WhenVerify]&]
[s2;%% If this event is defined it is invoked after a successful 
ssh`-2 protocol handshake to allow user to verify the host against 
a list of known (trusted) hosts. Returning false halts the connection 
process.&]
[s3; &]
[s4; &]
[s5;:Upp`:`:Ssh`:`:WhenKeyboard: [_^Upp`:`:Function^ Function]<[_^Upp`:`:String^ String](
Ssh[@(0.0.255) `&], [_^Upp`:`:String^ String], [_^Upp`:`:String^ String], 
[_^Upp`:`:String^ String])>_[* WhenKeyboard]&]
[s2;%% This callback is required by the [^topic`:`/`/SSH`/src`/Ssh`$en`-us`#Upp`:`:Ssh`:`:Interactive`(`)^ I
nteractive() ](challenge/response) authentication method. The 
host will issue one or more challenges and require a response 
for each challenge. Therefore this callback, responsible for 
obtaining responses, may be invoked more than once, and  has 
3 additional parameters (as strings): [*@3 title], [*@3 instructions], 
and [*@3 prompt]. The title and instructions may be empty strings. 
Returned responses will be evaluated by the designated host. 
Returning an empty string will halt the connection. See also 
[^topic`:`/`/SSH`/src`/Ssh`$en`-us`#Upp`:`:Ssh`:`:GetAuthMethods`(`)^ GetAuthMethod
s()], [^topic`:`/`/SSH`/src`/Ssh`$en`-us`#Upp`:`:Ssh`:`:Password`(`)^ Password()], 
[^topic`:`/`/SSH`/src`/Ssh`$en`-us`#Upp`:`:Ssh`:`:PublicKey`(`)^ PublicKey()].&]
[s2;%% &]
[s3; &]
[ {{10000F(128)G(128)@1 [s0;%% [* Constructor detail]]}}&]
[s3; &]
[s5;:Upp`:`:Ssh`:`:Ssh`(`): [* Ssh]()&]
[s2;%% Default constructor.&]
[s3; &]
[s4; &]
[s5;:Upp`:`:Ssh`:`:Ssh`(Upp`:`:ValueMap`): [* Ssh]([_^Upp`:`:ValueMap^ ValueMap]_[*@3 metho
ds])&]
[s2;%% Equivalent of default constructor and then invoking Methods([%-*@3 methods]). 
The provided [%-*@3 methods] list should contain key`-value pairs 
where the keys represent possible method types, and the values 
represent single or multiple [^topic`:`/`/SSH`/src`/SshTransport`$en`-us^ transport
 methods], with the most preferred listed as first and the least 
preferred as last. See also [^topic`:`/`/SSH`/src`/Ssh`$en`-us`#Upp`:`:Ssh`:`:Methods`(Upp`:`:ValueMap`)^ M
ethods()].&]
[s3;%% &]
[s4; &]
[s5;:Upp`:`:Ssh`:`:`~Ssh`(`): [@(0.0.255) `~][* Ssh]()&]
[s2;%% Destructor. If the client is not already disconnected, it 
will invoke [^topic`:`/`/SSH`/src`/Ssh`$en`-us`#Upp`:`:Ssh`:`:StartDisconnect`(`)^ D
isconnect()].&]
[s3; &]
[s0; &]
[ {{10000@(113.42.0) [s0;%% [*@7;4 Ssh`::Subsystem]]}}&]
[s1;@(0.0.255)3 &]
[s1;:Upp`:`:Ssh`:`:Subsystem`:`:class: [@(0.0.255)3 class][3 _][*3 Subsystem][3 _:_][@(0.0.255)3 p
rivate][3 _][*@3;3 NoCopy][3 , ][@(0.0.255)3 public][3 _][*@3;3 JobQueue]&]
[s2;#%% This nested class is the base class for SSH`-2 communication 
subsystems. It provides the means to bind the ssh subsystems 
to ssh sessions, [^https`:`/`/en`.wikipedia`.org`/wiki`/Run`-time`_type`_information`?oldformat`=true^ R
TTI] support for polymorphism, and queue support for both [/ synchronous 
]and [/ asynchronous ]modes of operation. Asynchronous subsystem 
requests can be queued sequentially for batch`-processing, and 
are managed mainly using [^topic`:`/`/JobQueue`/src`/JobQueue`$en`-us`#Upp`:`:JobQueue`:`:Do`(`)^ D
o()], [^topic`:`/`/JobQueue`/src`/JobQueue`$en`-us`#Upp`:`:JobQueue`:`:InProgress`(`)const^ I
nProgress()], [^topic`:`/`/JobQueue`/src`/JobQueue`$en`-us`#Upp`:`:JobQueue`:`:IsSuccess`(`)const^ I
sSuccess()], and [^topic`:`/`/JobQueue`/src`/JobQueue`$en`-us`#Upp`:`:JobQueue`:`:IsFailure`(`)const^ I
sFailure()] methods. See also [^topic`:`/`/JobQueue`/src`/JobQueue`$en`-us`#Upp`:`:JobQueue`:`:class^ J
obQueue]&]
[s3; &]
[ {{10000F(128)G(128)@1 [s0;%% [* Public Method List]]}}&]
[s3; &]
[s5;:Upp`:`:Ssh`:`:Subsystem`:`:Session`(Upp`:`:Ssh`&`): [@(0.0.255) void]_[* Session]([_^Upp`:`:Ssh^ S
sh][@(0.0.255) `&]_[*@3 session])&]
[s2;%% Binds the subsystem instance to a given [%-*@3 session]. In 
order for any ssh subsystem to be valid, it must be bound to 
a valid ssh session first. This can be done also in the constructor.&]
[s3;%% &]
[s4; &]
[s5;:Upp`:`:Ssh`:`:Subsystem`:`:ChunkSize`(size`_t`): [@(0.0.255) void]_[* ChunkSize](siz
e`_t_[*@3 sz])&]
[s2;%% Sets the chunk size to [%-*@3 sz] for data reads and writes.&]
[s3;%% &]
[s4; &]
[s5;:Upp`:`:Ssh`:`:Subsystem`:`:GetType`(`)const: [_^Upp`:`:Ssh`:`:Subsystem`:`:Type^ T
ype]_[* GetType]()_[@(0.0.255) const]&]
[s2;%% Returns the subsystem type identifier. [%-_^Upp`:`:Ssh`:`:Subsystem`:`:Type^ Typ
e] is a nested enumerator class containing 6 identifiers: [C UNDEFINED 
(reserved), CHANNEL, SFTP, SCP, EXEC, SHELL]&]
[s3; &]
[s4; &]
[s5;:Upp`:`:Ssh`:`:Subsystem`:`:To`(`): [@(0.0.255) template]_<[@(0.0.255) class]_[*@4 T]>_
[*@4 T][@(0.0.255) `&]_[* To]()&]
[s2;%% Converts the subsystem instance to type [%-*@4 T]. Returns a 
reference to [%-*@4 T ]on success, throws [^topic`:`/`/SSH`/src`/Ssh`$en`-us`#Upp`:`:Ssh`:`:Subsystem`:`:TypeError`:`:struct^ S
ubsystem`::TypeError] on failure.&]
[s3; &]
[s4; &]
[s5;:Upp`:`:Ssh`:`:Subsystem`:`:Is`(`)const: [@(0.0.255) template]_<[@(0.0.255) class]_[*@4 T
]>_[@(0.0.255) bool]_[* Is]()_[@(0.0.255) const]&]
[s2;%% Tests whether the subsystem is of type [%-*@4 T].&]
[s3; &]
[s4; &]
[s5;:Upp`:`:Ssh`:`:Subsystem`:`:Clear`(`): [@(0.0.255) void]_[* Clear]()&]
[s2;%% Clears queued (scheduled) asynchronous requests.&]
[s3; &]
[s0; &]
[ {{10000F(128)G(128)@1 [s0;%% [* Constructor detail]]}}&]
[s3; &]
[s5;:Upp`:`:Ssh`:`:Subsystem`:`:Subsystem`(`): [* Subsystem]()&]
[s2;%% Default constructor.&]
[s0; &]
[ {{10000F(128)G(128)@1 [s0;%% [* Miscellaneous]]}}&]
[s3; &]
[s1;:Upp`:`:Ssh`:`:Subsystem`:`:TypeError`:`:struct: [@(0.0.255)3 struct][3 _][*3 TypeError
][3 _:_][@(0.0.255)3 public][3 _][*@3;3 Exc]&]
[s2;%% This exceptions is thrown when subsystem type conversion has 
failed. See also [^topic`:`/`/SSH`/src`/Ssh`$en`-us`#Upp`:`:Ssh`:`:Subsystem`:`:To`(`)^ T
o()], and [^topic`:`/`/SSH`/src`/Ssh`$en`-us`#Upp`:`:Ssh`:`:Subsystem`:`:Is`(`)const^ I
s()].&]
[s3; &]
[s3; ]]